function value = value_fixed_leg_index(dates, T, coupon, portfolio, index_members, discounts, discounts_inbetween, maturities, ajd_common, y0)
% --------------------------------------------------------------------------------------------------
% Calculate the market value of the payments made by the buyer of protection for an index. This
% function is fully vectorized.
% --------------------------------------------------------------------------------------------------
% date_nums             ... datenums for which to compute value of fixed leg payments
% T                     ... time to maturity of index
% coupon                ... coupon rate of index
% index_members         ... indicator matrix with index members at each point in time
% discounts             ... discount curves (matching coupon payments, end of period)
% discounts_inbetween   ... discount curves (matching coupon payments, middle of period)
% maturities            ... which maturities to update (indicator vector), default: update all
% ajd_common            ... dynamics of common factor
% y0                    ... initial value(s) of common factor
% --------------------------------------------------------------------------------------------------
% sample call:
%{
    value_fixed_leg_index(datenum({'11/20/2006' '11/21/2006'}), [5; 4.9974], [78; 85], repmat(cds_test, 5, 1), [1 1 1 1 1; 1 1 1 1 0], ...
                                  exp(-0.05*repmat(0.25:0.25:5, 2, 1)), exp(-0.05*repmat((0.25:0.25:5)-1/8, 2, 1)))
%}
% --------------------------------------------------------------------------------------------------

% Compute expected quarterly portfolio notional and notional loss;
[exp_notional, exp_notional_loss] = expected_index_notional(dates, T, portfolio, index_members, maturities, ajd_common, y0);

% Compute market value of coupon payments for the index
value = zeros(length(dates), 1);
for i=1:length(dates)
    % If coupon is equal to (i.e. missing value), use coupon equal to 1bps, to at least calculate
    % the PV01
    if (coupon(i) == 0)
        coupon(i) = 1;
    end
    
    for t=1:ceil(T(i)*4) 
        % Add discounted payment to market value of tranche
        %value(i) = value(i) + coupon(i)/4/1e4 * (exp_notional(i,t)*discounts(i,t) + exp_notional_loss(i,t)*discounts_inbetween(i,t)/2);
        value(i) = value(i) + coupon(i)/4/1e4 * (365/360) * exp_notional(i,t) * discounts(i,t);
    end
    % Substract accrual at time of entering the index contract
    time_last_coupon = (ceil(T(i)*4) - T(i)*4)/4;
    value(i) = value(i) - coupon(i)/1e4/4/2 * (365/360) * time_last_coupon;
end